package jacob.tool;

import ccl.swing.SwingUtil;
import ccl.util.Util;
import jacob.JacobSecurityManager;
import jacob.Package;
import java.io.File;
import java.util.Vector;


/**
 * 
 * @author  Chr. Clemens Lee
 * @version $Id: JikesDebuggerWrapper.java,v 1.1 1999/02/22 11:44:17 clemens Exp clemens $
 */
public class JikesDebuggerWrapper extends WrapperAdapter {
    public JikesDebuggerWrapper() {
        super();
    }

    public void run() {
        jd.PublicDebugger pPublicDebugger = null;
        if ( Util.isEmpty( _pJacobInterface.getMainClass() ) ) {
            SwingUtil.showMessage( _pJacobInterface.getMainFrame(),
                                   "Could not start Jikes Debugger!\n" +
                                   "No main class set for project.\n" +
                                   "Go to 'Edit->Project Settings...' to set it." );
            
            super.run();

            return;
        }
        try {
            String sParameter = _pJacobInterface.
                   getStartParameter().trim();            
            sParameter = Util.removeMultipleSpaces( sParameter );
            Vector vParameter = Util.stringToLines
                   ( sParameter, ' ' );          
            String[] asArg = new String[ 1 + vParameter.size() ];
            asArg[ 0 ] = _pJacobInterface.getMainClass();
            for( int parameter = 0; parameter < vParameter.size(); parameter++ ) {
                asArg[ parameter + 1 ] = (String)vParameter.elementAt( parameter );
            }
            pPublicDebugger =
                   new jd.PublicDebugger( Package.getClassPath(),
                                          Package.getSourcePath(),
                                          false,
                                          (String)null,
                                          (String)null,
                                          "",
                                          asArg );
            pPublicDebugger.start();
            ((JacobSecurityManager)System.getSecurityManager()).
                   observeThread( pPublicDebugger );
            pPublicDebugger.join();
            pPublicDebugger.getFrame().dispose();
            pPublicDebugger = null;
            ((JacobSecurityManager)System.getSecurityManager()).
                   observeThread( null );            
        } catch( NoClassDefFoundError pError ) {
            SwingUtil.showMessage( _pJacobInterface.getMainFrame(),
                                   "Error while running Jikes Debugger!\n" +
                                   "Maybe you did not download and install IBM's\n" +
                                   "Jikes Debugger (http://www.alphaworks.ibm.com/).\n" +
                                   "Just add its jar file to jacob's classpath." );
        } catch( Exception pException ) {
        }
        
        super.run();
    }
}
