package jacob.tool;

import java.util.*;
import java.awt.Frame;

import jacob.*;

import ccl.util.*;
import ccl.awt.AWTUtil;

/**
 * A wrapper for JavaDump. Author of JavaDump is Matt Yourst.
 *
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: JavaDumpWrapper.java,v 1.1 1998/02/28 22:48:24 clemens Exp clemens $
 * @see JavancssAll
 */
public class JavaDumpWrapper implements JacobRunnable {
	private JacobInterface _pJacobInterface = null;
	private String _sToolName = "";

	public JavaDumpWrapper() {
		super();
	}

	public void set(JacobInterface pJacobInterface_) {
		Util.panicIf(pJacobInterface_ == null);
		_pJacobInterface = pJacobInterface_;
	}

	public void run() {
		String sClassFullName = _pJacobInterface.getSelectedClass();
		_sToolName = "JavaDump " + sClassFullName;
		if (Util.isEmpty(sClassFullName)) {
			Frame frmMain = _pJacobInterface.getMainFrame();
			AWTUtil.showMessage(frmMain, "JavaDumpWrapper: Sorry, no class selected!");
			frmMain.requestFocus();
			_pJacobInterface.stopped(this);

			return;
		}

		// get path of class
		Package pckMain = _pJacobInterface.getMainPackage();
		String sClassFullFileName = pckMain.getClassFullFileName
				 (sClassFullName);
		sClassFullFileName = Util.replace(sClassFullFileName,
													 ".java", ".class");

		String[] asArg = new String[2];
		asArg[0] = sClassFullFileName;

		String sOutputFile = FileUtil.concatPath
				 (_pJacobInterface.getInit().getApplicationPath(),
				  "JavaDump.txt");
		asArg[1] = sOutputFile;

		try {
			jacob.jcf.javadump.main(asArg);
			_pJacobInterface.editFile(sOutputFile);
		} catch(Exception e) {
			Util.debug("JavaDumpWrapper.run().e: " + e);
		}
		_pJacobInterface.stopped(this);
	}

	public String toString() {
		return _sToolName;
	}
}
