package jacob;

import java.io.*;
import java.util.Enumeration;
import java.util.Vector;

import ccl.util.Util;
import ccl.util.FileUtil;
import ccl.awt.AWTUtil;

import jacob.tool.JacobInterface;

/**
 *
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: EmacsEditor.java,v 1.7 1999/02/22 11:44:04 clemens Exp clemens $
 */
public class EmacsEditor extends EditorAdapter
                         implements JacobConstants 
{
    protected static final String S_GNUDOIT = "gnudoit";
    protected static final String S_EMACS = "gnuclient";
    
    protected boolean _bWorking;
    private String _sGnudoitFullName = "";
    
    private void _findFile(String sFileFullName_) {
        if (!Util.isOSWindows()) {
            system("(find-file \"" + Util.replace(sFileFullName_,
                                                  '\\', '/') + "\")");
        } else {
            // Filename must have lower drive letter because of gnuclient.
            // Otherwise it does make trouble with Samba.
            String sNewFullFileName = new String(sFileFullName_);
            if (sNewFullFileName.charAt(1) == ':' &&
                Character.isUpperCase(sNewFullFileName.charAt(0)))
            {
                sNewFullFileName = Util.firstCharToLowerCase(sNewFullFileName);
            }
            system("(find-file \\\"" + Util.replace(sNewFullFileName,
                                                    '\\', '/') + "\\\")");
        }
    }
    
    private void _bringEmacsToFront(String sFileFullName_) {
        if (!_bWorking) {
            return;
        }
        
        if (Util.isOSWindows()) {
            // return if xemacs or user does not want to use gnuclient
            String sLine = system("(if (= (point-min) (point-max)) 1 (if (= (point) (point-max)) (progn (if (= (current-column) 0) (1+ (count-lines 1 (point))) (count-lines 1 (point)) ) ) (progn (count-lines 1 (1+ (point))) ) ) )");
            int indexEndOfLine = sLine.indexOf('\n');
            if (indexEndOfLine == -1) {
                sLine = "1";
            } else {
                sLine = sLine.substring(0, indexEndOfLine);
            }
            
            // Filename must have lower drive letter because of gnuclient.
            // sehr wahrscheinlich muss daher auch findfile mit kleinem drive
            // letter ausgestattet werden.
            String sNewFullFileName = new String(sFileFullName_);
            if (sNewFullFileName.charAt(1) == ':' &&
                Character.isUpperCase(sNewFullFileName.charAt(0)))
            {
                sNewFullFileName = Util.firstCharToLowerCase(sNewFullFileName);
            }
            
            String sGnuservPath =_pJacobInterface.getInit().
                   getKeyValue(S_INIT_GNUCLIENT_PATH);
            Vector vArgs = new Vector();
            vArgs.addElement(FileUtil.concatPath(sGnuservPath, S_EMACS));
            vArgs.addElement("+" + sLine);
            vArgs.addElement(sNewFullFileName);
            // Wenn Parameter weiter vorne stehen, dann Fehler
            vArgs.addElement("-q");
            vArgs.addElement("-F");
            Util.debug(vArgs);
            try {
                Process pProcess = Util.system(vArgs);
                pProcess.waitFor();
            } catch(Exception e) {
                Util.debug( "EmacsEditor._bringEmacsToFront(..).e: " +
                            e );
                _bWorking = false;
                AWTUtil.showMessage("Error: the gnuclient helper application did not execute properly.\n" +
                                    "Maybe it is not properly installed together with the Emacs editor.\n" +
                                    "You can find the install documentation of the gnuserv package for the ntemacs at:\n" +
                                    "http://www.cs.washington.edu/homes/voelker/ntemacs.html#assoc");
                _pJacobInterface.getMainFrame().toFront();
                _pJacobInterface.getMainFrame().requestFocus();
            }
        }
    }
    
    public EmacsEditor() {
        super();
        _bWorking = true;
    }
    
    /*
     * --- overwritten methods of class 'jacob.EditorAdapter' ---
     */
    
    public void init(JacobInterface pJacobInterface_) {
        super.init(pJacobInterface_);
        _sGnudoitFullName = FileUtil.concatPath(_pJacobInterface.getInit().
                                                getKeyValue(S_INIT_GNUCLIENT_PATH),
                                                S_GNUDOIT);
    }
    
    public void editFile(String sFullFileName_) {
        if (!_bWorking) {
            return;
        }
        
        _findFile(sFullFileName_);
        
        _bringEmacsToFront(sFullFileName_);
    }
    
    public void saveCurrentFile() {
        system( "(save-buffer)" );
    }

    public String getCurrentFileName() {
        String sRetVal = system( "(buffer-file-name)" );
        sRetVal = Util.rtrim( sRetVal );
        
        return sRetVal;
    }

    public void editMethod(String param1_, String param2_) {
    }
    
    /**
     * Jump to method in current file.
     */
    public boolean editMethod( String sMethod_ ) {
        boolean bError = false;

        // Build Elisp Regexp Search String ------------------
        String sMethodOrig = Util.replace(sMethod_, "[]", "");
        int indexOpen = sMethodOrig.indexOf('(');
        if (indexOpen == -1) {
            Util.println("Jacob warning in jacob.Jacob._findMethod(String): Method '" + sMethod_ + "' has wrong format!");
            return true;
        }
        String sMethodName = sMethodOrig.substring(0, indexOpen);
        // cut inner classes
        Vector vClasses = Util.stringToLines(sMethodName, '.');
        sMethodName = (String)vClasses.elementAt(vClasses.size() - 1);
        vClasses.removeElementAt(vClasses.size() - 1);
        
        String sMethodBody = sMethodOrig.substring
               (indexOpen + 1, sMethodOrig.length() - 1);
        Vector vParameterTypes = Util.stringToLines(sMethodBody, ',');
        String sTabAndNewline = "\t\n";
        String sQuotationMark = "\"";
        if (Util.isOSWindows()) {
            sTabAndNewline = "\\t\\n";
            sQuotationMark = "\\\"";
        }
        String sDelimiter = "[ " + sTabAndNewline + "]+";
        // vor funktion muss ja mindestens ein return type sein.
        String sElispReSearch =
               sDelimiter + "[^- =*/+()<>{}" +
               sTabAndNewline + "]+" +
               sDelimiter +
               sMethodName + "[ " + sTabAndNewline + "]*(";
        if (vParameterTypes.size() == 0) {
            sElispReSearch += "[ " + sTabAndNewline + "]*";
        }
        for(Enumeration eTypes = vParameterTypes.elements(); eTypes.hasMoreElements(); ) {
            String sType = (String)eTypes.nextElement();
            sElispReSearch += "\\\\(final \\\\)?[ " + sTabAndNewline + "]*" + sType + "[^,)]+";
            if (eTypes.hasMoreElements()) {
                sElispReSearch += ",";
            }
        }
        sElispReSearch += ")";
        Util.debug("Jacob.editMethod().sElispReSearch: " + sElispReSearch);
        
        system("(beginning-of-buffer)");
        
        for(Enumeration eClasses = vClasses.elements(); eClasses.hasMoreElements(); ) {
            String sEmacsAnswer = system("(re-search-forward " + sQuotationMark +
                                         "[+=({ " + sTabAndNewline +
                                         "]+\\\\(class\\\\|new\\\\)" +
                                         sDelimiter + ((String)eClasses.nextElement()) + "[ " + sTabAndNewline + "{(]" +
                                         sQuotationMark + ")");
            Util.debug( "EmacsEditor.editMethod(..).sEmacsAnswer: " +
                        sEmacsAnswer );
            bError = bError || sEmacsAnswer.startsWith( "(search-failed " );            
        }
        
        system("(re-search-forward " + sQuotationMark + sElispReSearch +
                 sQuotationMark + ")");
        
        system("(beginning-of-line)");

        return bError;
    }

    public void insertString( String pString_ ) {
        system( "(insert \"" + pString_ + "\")" );
    }

    /**
     * This method has an intended side effect on emacs.
     * before jumping it makes a (set-mark-command) so
     * the user can easily jump back to the old position.
     */
    public void gotoLine( int line_ ) {
        system( "(set-mark (point))(goto-line " + line_ + ")" );
    }

    public void gotoColumn( int column_ ) {
        system( "(beginning-of-line)" );
        if ( column_ > 1 ) {
            system( "(forward-char " + (column_ - 1) + ")" );
        }
    }

    public String getCurrentWord() {
        String sRetVal = system( "(current-word)" );
        sRetVal = Util.rtrim( sRetVal );

        return sRetVal;
    }

    public void setColumnWidth(int param1_) {
    }
    
    /**
     * It executes gnudoit.
     */
    public String system(String sELispCommand_) {
        String sRetVal = "";
        
        if (!_bWorking) {
            return sRetVal;
        }
        
        try {
            Vector vArgs = new Vector();
            vArgs.addElement(_sGnudoitFullName);
            vArgs.addElement(sELispCommand_);
            Util.debug("EmacsEditor.system(..).vArgs: " + vArgs);
            Process pProcess = Util.system(vArgs);
            try {
                DataInputStream disGnudoit = new DataInputStream(pProcess.getInputStream());
                while(true) {
                    byte bNext = disGnudoit.readByte();
                    if ( bNext != 13 && bNext != 10 ) {
                        sRetVal += Util.byteToString(bNext);
                    }
                }
            } catch(Exception eStream) {
                Util.debug("EmacsEditor.system(..).eStream: " + eStream);
            }
            Util.debug("EmacsEditor.system(..).sRetVal: " + sRetVal);
            
            // This might be the problem, David. Try without it.
            pProcess.waitFor();
            
        } catch(Exception eGnudoit) {
            _bWorking = false;
            Util.debug("EmacsEditor.system(..).sELispCommand_: " + sELispCommand_);
            Util.debug("EmacsEditor.system(..).eGnudoit: " + eGnudoit);
            java.awt.Frame frmDummy = new java.awt.Frame();
            frmDummy.pack();
            // this is not good. If something like this happens, EditorAdapter
            // (NoEditor) should be used instead of this one not working correctly
            // could be done with EditorAdapter evaluating the return String
            AWTUtil.showMessage(frmDummy,
                                "Error: the gnudoit helper application did not execute properly.\n" +
                                "Maybe it is not properly installed together with the Emacs editor.\n" +
                                "You can find the installing documentation of the gnuserv package for the ntemacs at:\n" +
                                "http://www.cs.washington.edu/homes/voelker/ntemacs.html#assoc");
            _pJacobInterface.getMainFrame().requestFocus();
        }
        
        return sRetVal;
    }
}
