/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_config_mem.h"
 *                                    created: 29/10/97 {1:15:17 pm} 
 *                                last update: 19/11/97 {1:59:11 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  29/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_config_mem_
#define _Cpptcl_cpptcl_config_mem_

#include "cpptcl_member_base.icc"


//@Section: Cpptcl library
//@Man: 
DLL_EXPORT
class cpp_config_mem: public cpp_mem {
	friend tcl_args_reader& operator >> (tcl_args_reader& arg, const cpp_config_mem& mem);
  protected:
    ///
    cpp_config_mem(const cpp_config_mem& c):cpp_mem(c) {}
  public:
	Cpptcl_BaseClass(cpp_config_mem);
    ///
	virtual const char* data_type(void) const=0;
    ///
	virtual void tcl_set(tcl_object* o, tcl_args_reader& t) const=0;
    ///
	cpp_config_mem(const char* n):cpp_mem(n) {}
	~cpp_config_mem(void) {}
    ///
	int parse_meta_commands(tcl_obj& tcl_, tcl_args& arg);
	///
	virtual bool read_only(void) const {return false;}
    ///
    void conversion_error(tcl_args& arg) const;
	///
	int parse_tcl_command(tcl_args& arg) {
		return cpp_mem::configure_member(arg);
	}
};

#endif
