{$W-,R+,V-,G+,S+}
unit wbibtga;

interface

Uses
  WinTypes,WinProcs,WObjects,Strings,Win31,wbibbmp,wbibdisp,bibstrg,
  bibfile,lfnunit;


function LoadTargaDIB(Name: PChar; var Width, Height: LongInt): THandle;

implementation

type
  PalRec = record
    blue,green,red: byte;
  end;
  pal = array[0..255] of PalRec;
  TGAHeader = record
    J1: word;                { Reserved                     }
    TGAType: byte;           { Type: 1 = 8 bit, 2 = 24 bit, 3 = 8 bit grayscale } 
    J2: array[0..8] of char; { Reserved                     }
    xsize,ysize: word;       { Dimension                    }
    bpp: byte;               { Bits per pixel               }
    Storage: byte;           { 32 = top down, 0 = bottom up }
  end;


function LoadTargaDIB(Name: PChar; var Width, Height: LongInt): THandle;
var
  tgapal    : ^pal;
  fil       : file;
  i,PixSize : integer;
  TableSize,BitmapInfoSize,Sel,Offset,ToLoad,Loaded: word;
  BitmapInfo: PBitmapInfo;
  DIB: THandle;
  Bit: LongType;
  TotPixels,LineSize,LineBufSize,Y: longint;
  LineBuffer,P: PChar;
  Header: TGAHeader;

procedure DrawLine(Y: integer);
begin
  if Header.Storage=32 then Y:=Height-Y-1;
  DrawBitLine(Bit,LineBuffer,LineSize,LineBufSize,Y);
end;            { DrawLine }

begin                  { LoadTargaDIB }
  Width:=0; Height:=0; LoadTargaDIB:=0; TGAPal:=Nil; BitmapInfo:=Nil;
  TableSize:=256;
  LFNNew(fil,false); LFNAssign(fil,StrPas(Name));
  if LFNReset(fil,1)<>0 then
  begin
    LFNDispose(fil); Exit;
  end;
  FillChar(Header,sizeof(Header),$FF);
  BlockRead(fil,Header,sizeof(Header));

  with Header do
  if not ((Storage in [0,32]) and (TGAType in [1..3])) then
  begin
    LFNDispose(fil); Exit;
  end;

  Width:=Header.xsize; Height:=Header.YSize;
  PixSize:=Header.bpp div 8;
  case Header.TGAType of
    3: TableSize:=256;
    2: TableSize:=0;
    1: TableSize:=256;
  end;
  LineBufSize:=Width*PixSize;
  LineSize:=LineBufSize;
  if LineSize mod 4 <> 0 then LineSize:=4*(LineSize div 4)+4;
  TotPixels:=Header.xsize*Header.ysize*PixSize;

  BitmapInfoSize:=sizeof(TBitmapInfoHeader)+(TableSize)*sizeof(TRGBQuad);
  DIB:=GlobalAlloc(GHND,BitmapInfoSize+LineSize*Header.Ysize+1024);
  BitmapInfo:=GlobalLock(DIB);
  FillChar(BitmapInfo^,BitmapInfoSize,0);

  with BitmapInfo^ do
  begin
    with bmiHeader do
    begin
      biSize         :=sizeof(TBitmapInfoHeader);
      biWidth        :=Width;
      biHeight       :=Height;
      biPlanes       :=1;
      biBitCount     :=Header.bpp;
      biCompression  :=BI_RGB;
      biSizeImage    :=0;
      biXPelsPerMeter:=2000;
      biYPelsPerMeter:=2000;
      biClrUsed      :=TableSize;
      biClrImportant :=0;
    end;
{$UNDEF RPLUS}
{$IFDEF R+}
  {$DEFINE RPLUS}
{$ENDIF}
    {$R-}
    if Header.TGAType=1 then
    begin
      New(TGAPal); blockread(fil,tgapal^,sizeof(tgapal^));
    end;
    for i:=0 to TableSize-1 do
    with bmiColors[i] do
    begin
      if Header.TGAType=3 then   { GrayScale }
      begin
        rgbBlue:=i; rgbGreen:=i; rgbRed:=i;
      end else
      begin
        rgbBlue    :=TGAPal^[i].Blue;
        rgbGreen   :=TGAPal^[i].Green;
        rgbRed     :=TGAPal^[i].Red;
        rgbReserved:=0;
      end;
    end;
{$IFDEF RPLUS}
    {$R+}
    {$UNDEF RPLUS}
{$ENDIF}
  end;
  if TGAPal<>Nil then Dispose(TGAPal);

  Bit.ptr:=PChar(BitmapInfo)+BitmapInfoSize;

  GetMem(LineBuffer,LineBufSize);
  for Y:=0 to Height-1 do
  begin
    BlockRead(fil,LineBuffer^,LineBufSize);
    DrawLine(Y);
  end;
  FreeMem(LineBuffer,LineBufSize);

  LFNDispose(fil);
  GlobalUnlock(DIB);
  LoadTargaDIB:=DIB;
end;                    { LoadTargaDIB }


end.
