/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.io;

import com.izforge.izpack.io.VolumeNotFoundException;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class FileSpanningInputStream
extends InputStream {
    private static final int EOF = -1;
    protected FileInputStream fileinputstream;
    protected String volumename;
    protected int currentvolumeindex;
    protected int volumestotal;
    protected static boolean nextvolumenotfound = false;
    protected long filepointer;
    protected GZIPInputStream zippedinputstream;

    public FileSpanningInputStream(File volume, int volumestotal) throws IOException {
        this.fileinputstream = new FileInputStream(volume);
        this.zippedinputstream = new GZIPInputStream(this.fileinputstream);
        this.currentvolumeindex = 0;
        this.volumename = volume.getAbsolutePath();
        this.volumestotal = volumestotal;
        this.filepointer = 0L;
        Debug.trace("Opening stream to " + volume);
    }

    public FileSpanningInputStream(String volumename, int volumestotal) throws IOException {
        this(new File(volumename), volumestotal);
    }

    private boolean createInputStreamToNextVolume() throws IOException {
        ++this.currentvolumeindex;
        if (this.currentvolumeindex >= this.volumestotal) {
            Debug.error("last volume reached.");
            return false;
        }
        String nextvolumename = this.volumename + "." + this.currentvolumeindex;
        Debug.trace("Trying to use next volume: " + nextvolumename);
        File nextvolumefile = new File(nextvolumename);
        if (!nextvolumefile.exists()) {
            --this.currentvolumeindex;
            nextvolumenotfound = true;
            Debug.trace("volume not found");
            throw new VolumeNotFoundException(nextvolumename + "was not found.", nextvolumename);
        }
        Debug.trace("next volume found.");
        this.fileinputstream = new FileInputStream(nextvolumefile);
        this.zippedinputstream = new GZIPInputStream(this.fileinputstream);
        nextvolumenotfound = false;
        return true;
    }

    public int available() throws IOException {
        if (nextvolumenotfound) {
            this.createInputStreamToNextVolume();
        }
        return this.zippedinputstream.available();
    }

    public void close() throws IOException {
        this.zippedinputstream.close();
        this.fileinputstream.close();
    }

    public int read() throws IOException {
        if (nextvolumenotfound) {
            this.createInputStreamToNextVolume();
        }
        int nextbyte = this.zippedinputstream.read();
        ++this.filepointer;
        if (nextbyte == -1) {
            try {
                this.zippedinputstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.createInputStreamToNextVolume()) {
                nextbyte = this.zippedinputstream.read();
                ++this.filepointer;
            }
        }
        return nextbyte;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (nextvolumenotfound) {
            this.createInputStreamToNextVolume();
        }
        int bytesread = this.zippedinputstream.read(b, off, len);
        this.filepointer += (long)bytesread;
        if (bytesread == -1) {
            ++this.filepointer;
            System.out.println("EOF reached.");
            try {
                this.zippedinputstream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.createInputStreamToNextVolume()) {
                Debug.trace("next volume opened, continuing read");
                bytesread = this.zippedinputstream.read(b, off, len);
                this.filepointer += (long)bytesread;
            }
        }
        return bytesread;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        long bytesskipped;
        if (nextvolumenotfound) {
            this.createInputStreamToNextVolume();
        }
        byte[] buffer = new byte[4096];
        try {
            int bytesInBuffer;
            for (bytesskipped = 0L; bytesskipped < n; bytesskipped += (long)bytesInBuffer) {
                int maxBytes = (int)Math.min(n - bytesskipped, (long)buffer.length);
                bytesInBuffer = this.read(buffer, 0, maxBytes);
                if (bytesInBuffer != -1) continue;
                throw new IOException("Unexpected end of stream (installer corrupted?)");
            }
        }
        catch (VolumeNotFoundException vnfe) {
            vnfe.setAlreadyskippedbytes(bytesskipped);
            throw vnfe;
        }
        return bytesskipped;
    }

    public String getVolumename() {
        return this.volumename;
    }

    public void setVolumename(String volumename) {
        Debug.trace("new volumename: " + volumename);
        String volumesuffix = "." + this.currentvolumeindex;
        String nextvolumesuffix = "." + (this.currentvolumeindex + 1);
        this.volumename = volumename.endsWith(volumesuffix) ? volumename.substring(0, volumename.lastIndexOf(volumesuffix)) : (volumename.endsWith(nextvolumesuffix) ? volumename.substring(0, volumename.lastIndexOf(nextvolumesuffix)) : volumename);
        Debug.trace("Set volumename to: " + this.volumename);
    }

    public long getFilepointer() {
        return this.filepointer;
    }
}

