/* Example code to log to Event log. */

#include <windows.h>
#include <stdio.h>
#include <syslog.h>
#include "name.h"


#define TBUF_LEN        2048
#define FMT_LEN         1024

static HANDLE	hEventLog;				/* handle to the Event Log. */
static int      opened;                 /* have done openlog() */
static int      LogStat = 0;            /* status bits, set by openlog() */
static char		*LogTag = NULL;				/* string to tag the entry with */

void syslog(int pri, char *fmt, ...)
{
        va_list ap;
        va_start(ap, fmt);
        vsyslog(pri, fmt, ap);
        va_end(ap);
}

void vsyslog(int pri, char *fmt, va_list ap){
	char ch, *p, *t;
	int tbuf_left, fmt_left, prlen, saved_errno;
	char tbuf[TBUF_LEN], fmt_cpy[FMT_LEN];

	p = tbuf;
	tbuf_left = TBUF_LEN;

	saved_errno = errno;

        /*
         * We wouldn't need this mess if printf handled %m, or if
         * strerror() had been invented before syslog().
         */
        for (t = fmt_cpy, fmt_left = FMT_LEN; (ch = *fmt); ++fmt) {
                if (ch == '%' && fmt[1] == 'm') {
                        ++fmt;
                        prlen = _snprintf(t, fmt_left, "%s",
                            strerror(saved_errno));
                        if (prlen >= fmt_left)
                                prlen = fmt_left - 1;
                        t += prlen;
                        fmt_left -= prlen;
                } else {
                        if (fmt_left > 1) {
                                *t++ = ch;
                                fmt_left--;
                        }
                }
        }
        *t = '\0';

	_vsnprintf(p, tbuf_left, fmt_cpy, ap);
	
	/* Get connected, output the message to the local logger. */
	if (!opened)
		openlog(LogTag, LogStat, 0);

	/* Now, actually report it. */
	if (!ReportEvent(hEventLog, EVENTLOG_INFORMATION_TYPE, 0, MSG, NULL, 1, 0, (char **)&p, NULL))
         return;
}

void openlog(char *ident, int logstat, int logfac){

	if(ident != NULL){
		LogTag = ident;
        LogStat = logstat;
	  /* Add the registry key each time openlog is called. */
	  AddEventSource(ident);

	  hEventLog = RegisterEventSource(NULL, ident);
      if (hEventLog == NULL)
		 return;
	}
	opened = 1;
}

void closelog()
{
        DeregisterEventSource(hEventLog);
}

/* Taken from MSDN. */
void AddEventSource(char *ident)
{
    HKEY hk; 
    DWORD dwData; 
    char szFilePath[_MAX_PATH];
	char key[_MAX_PATH];
	
    // Add your source name as a subkey under the Application 
    // key in the EventLog registry key. 
    _snprintf(key, sizeof(key), "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\%s", ident);

    if (RegCreateKey(HKEY_LOCAL_MACHINE, key, &hk)) {
		printf("Could not create the registry key."); 
		exit(-1);
	}
 
    // Set the name of the message file. 
	GetModuleFileName(NULL, szFilePath, sizeof(szFilePath));
    // Add the name to the EventMessageFile subkey. 
 
    if (RegSetValueEx(hk,             // subkey handle 
            "EventMessageFile",       // value name 
            0,                        // must be zero 
            REG_EXPAND_SZ,            // value type 
            (LPBYTE) szFilePath,           // pointer to value data 
            strlen(szFilePath) + 1)) {       // length of value data 
        printf("Could not set the event message file."); 
		exit(-1);
	}
 
    // Set the supported event types in the TypesSupported subkey. 
 
    dwData = EVENTLOG_ERROR_TYPE | EVENTLOG_WARNING_TYPE | 
        EVENTLOG_INFORMATION_TYPE | EVENTLOG_AUDIT_SUCCESS | EVENTLOG_AUDIT_FAILURE; 
 
    if (RegSetValueEx(hk,      // subkey handle 
            "TypesSupported",  // value name 
            0,                 // must be zero 
            REG_DWORD,         // value type 
            (LPBYTE) &dwData,  // pointer to value data 
            sizeof(DWORD))){    // length of value data 
        printf("Could not set the supported types."); 
		exit(-1);
	}
 
    RegCloseKey(hk); 
} 
