/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRStyledText;

public class TextDrawer
extends ElementDrawer {
    protected TextRenderer textRenderer;

    public TextDrawer(TextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintText text = (JRPrintText)element;
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        String allText = styledText.getText();
        int x = text.getX() + offsetX;
        int y = text.getY() + offsetY;
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = text.getLineBox().getTopPadding();
        int leftPadding = text.getLineBox().getLeftPadding();
        int bottomPadding = text.getLineBox().getBottomPadding();
        int rightPadding = text.getLineBox().getRightPadding();
        double angle = 0.0;
        switch (text.getRotationValue()) {
            case LEFT: {
                y = text.getY() + offsetY + text.getHeight();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
            case RIGHT: {
                x = text.getX() + offsetX + text.getWidth();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
            case UPSIDE_DOWN: {
                int tmpPadding = topPadding;
                x = text.getX() + offsetX + text.getWidth();
                y = text.getY() + offsetY + text.getHeight();
                topPadding = bottomPadding;
                bottomPadding = tmpPadding;
                tmpPadding = leftPadding;
                leftPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = Math.PI;
                break;
            }
        }
        grx.rotate(angle, x, y);
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            grx.setColor(text.getBackcolor());
            grx.fillRect(x, y, width, height);
        }
        if (allText.length() > 0) {
            grx.setColor(text.getForecolor());
            this.textRenderer.render(grx, x, y, width, height, topPadding, leftPadding, bottomPadding, rightPadding, text.getTextHeight(), text.getHorizontalAlignmentValue(), text.getVerticalAlignmentValue(), text.getLineSpacingFactor(), text.getLeadingOffset(), text.getFontSize(), !"none".equals(text.getMarkup()), styledText, allText);
        }
        grx.rotate(-angle, x, y);
        this.drawBox(grx, text.getLineBox(), text, offsetX, offsetY);
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return textElement.getStyledText(JRStyledTextAttributeSelector.NO_BACKCOLOR);
    }
}

