/*
 * Decompiled with CFR 0.152.
 */
package ibd;

import blbutil.Const;
import blbutil.IntPair;
import java.text.DecimalFormat;
import vcf.Marker;

public final class IbdSegment {
    private static final DecimalFormat df2 = new DecimalFormat("0.00");
    private final IntPair hapPair;
    private final Marker start;
    private final Marker end;
    private final float score;
    private final int startIndex;
    private final int endIndex;

    public IbdSegment(IntPair intPair, Marker marker, Marker marker2, float f, int n, int n2) {
        this.checkArguments(intPair, marker, marker2, f, n, n2);
        this.hapPair = intPair;
        this.start = marker;
        this.end = marker2;
        this.score = f;
        this.startIndex = n;
        this.endIndex = n2;
    }

    private void checkArguments(IntPair intPair, Marker marker, Marker marker2, float f, int n, int n2) {
        if (intPair.first() < 0 || intPair.second() <= intPair.first()) {
            throw new IllegalArgumentException(intPair.toString());
        }
        if (marker.chromIndex() != marker2.chromIndex() || marker2.pos() < marker.pos()) {
            String string = Const.nl + marker + Const.nl + marker2;
            throw new IllegalArgumentException(string);
        }
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        if (n < -1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n2 < -1) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IbdSegment)) {
            return false;
        }
        IbdSegment ibdSegment = (IbdSegment)object;
        if (!this.hapPair.equals(ibdSegment.hapPair)) {
            return false;
        }
        if (!this.start.equals(ibdSegment.start)) {
            return false;
        }
        if (!this.end.equals(ibdSegment.end)) {
            return false;
        }
        return Float.floatToIntBits(this.score) == Float.floatToIntBits(ibdSegment.score);
    }

    public int hashCode() {
        int n = 5;
        n = 67 * n + this.hapPair.hashCode();
        n = 67 * n + this.start.hashCode();
        n = 67 * n + this.end.hashCode();
        n = 67 * n + Float.floatToIntBits(this.score);
        return n;
    }

    public int hap1() {
        return this.hapPair.first();
    }

    public int hap2() {
        return this.hapPair.second();
    }

    public IntPair hapPair() {
        return this.hapPair;
    }

    public Marker start() {
        return this.start;
    }

    public Marker end() {
        return this.end;
    }

    public float score() {
        return this.score;
    }

    public int startIndex() {
        return this.startIndex;
    }

    public int endIndex() {
        return this.endIndex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.hapPair.first());
        stringBuilder.append('\t');
        stringBuilder.append(this.hapPair.second());
        stringBuilder.append('\t');
        stringBuilder.append(this.start.chrom());
        stringBuilder.append('\t');
        stringBuilder.append(this.start.pos());
        stringBuilder.append('\t');
        stringBuilder.append(this.end.pos());
        stringBuilder.append('\t');
        stringBuilder.append(df2.format(this.score));
        return stringBuilder.toString();
    }
}

