/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class ValidityChecker {
    public static int nbCheck = 0;
    protected IntDomainVar[] sortedvs;
    protected int[] position;
    protected HashMap<IntDomainVar, Integer> mapinit;
    protected VarComparator vcomp;
    protected int arity;

    public ValidityChecker(int ari, IntDomainVar[] vars) {
        this.arity = ari;
        this.vcomp = new VarComparator();
        this.sortedvs = new IntDomainVar[this.arity];
        this.mapinit = new HashMap(this.arity);
        this.position = new int[this.arity];
        for (int i = 0; i < vars.length; ++i) {
            this.sortedvs[i] = vars[i];
            this.mapinit.put(vars[i], i);
            this.position[i] = i;
        }
    }

    public void sortvars() {
        Arrays.sort(this.sortedvs, this.vcomp);
        for (int i = 0; i < this.arity; ++i) {
            this.position[i] = this.mapinit.get(this.sortedvs[i]);
        }
    }

    public boolean isValid(int[] tuple) {
        for (int i = 0; i < this.arity; ++i) {
            if (this.sortedvs[i].canBeInstantiatedTo(tuple[this.position[i]])) continue;
            return false;
        }
        return true;
    }

    public boolean isValid(int[] tuple, int i) {
        return this.sortedvs[i].canBeInstantiatedTo(tuple[this.position[i]]);
    }

    public static class VarComparator
    implements Comparator {
        public int compare(Object o, Object o1) {
            IntDomainVar v1 = (IntDomainVar)o;
            IntDomainVar v2 = (IntDomainVar)o1;
            if (v1.getDomainSize() < v2.getDomainSize()) {
                return -1;
            }
            if (v1.getDomainSize() == v2.getDomainSize()) {
                return 0;
            }
            return 1;
        }
    }
}

