/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco.discrete;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.discrete.DiscreteModel;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;

public class DiscreteModelEvaluation
implements IFunctionInstance {
    private DataBlock m_c;
    private double m_f = Double.NaN;
    private Matrix m_hessian;
    private DiscreteModel m_model;

    public DiscreteModelEvaluation(DiscreteModel model, IReadDataBlock p) {
        this.m_model = model;
        this.m_c = new DataBlock(p);
    }

    public DiscreteModel getModel() {
        return this.m_model;
    }

    public double[] gradient() {
        double[] g = this.m_model.loglikelihoodGradient(this.m_c);
        for (int i = 0; i < g.length; ++i) {
            g[i] = -g[i];
        }
        return g;
    }

    public Matrix hessian() {
        Matrix m = this.m_model.logLikelihoodHessian(this.m_c);
        m.chs();
        return m;
    }

    public double[] probabilities() {
        return this.m_model.probabilities(this.m_c);
    }

    @Override
    public IReadDataBlock getParameters() {
        return this.m_c;
    }

    @Override
    public double getValue() {
        return this.calc();
    }

    private double calc() {
        if (Double.isNaN(this.m_f)) {
            this.m_f = -this.m_model.loglikelihood(this.m_c);
        }
        return this.m_f;
    }
}

