/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tipstatesmodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evomodel.treedatalikelihood.TipStateAccessor;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TimeVaryingFrequenciesModel
extends AbstractModelLikelihood
implements Citable {
    private final List<Epoch> epochs;
    private final List<TipStateAccessor> accessors;
    private final Tree tree;
    private final Taxon taxon;
    private final Parameter tipHeight;
    private boolean likelihoodKnown = false;
    private double storedLogLikelihood;
    private double logLikelihood;
    private static final boolean DEBUG = false;
    public static Citation CITATION = new Citation(new Author[]{new Author("MA", "Suchard"), new Author("JE", "Pekar")}, Citation.Status.IN_PREPARATION);

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.PRIOR_MODELS;
    }

    @Override
    public String getDescription() {
        return "Time-varying integration of unobserved tip trait";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    public TimeVaryingFrequenciesModel(String string, List<TipStateAccessor> list, List<Epoch> list2, Taxon taxon, Tree tree, Parameter parameter) {
        super(string);
        this.accessors = list;
        this.epochs = list2;
        this.tree = tree;
        this.taxon = taxon;
        this.tipHeight = parameter;
        if (parameter != null) {
            parameter.addVariableListener(this);
        }
        list2.sort(Comparator.comparingDouble(epoch -> epoch.cutOff));
        this.getTipNode(taxon);
    }

    public List<TipStateAccessor> getAccessors() {
        return this.accessors;
    }

    public Tree getTree() {
        return this.tree;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public int getTipIndex(Taxon taxon) {
        int n = this.tree.getTaxonIndex(taxon);
        if (n == -1) {
            throw new RuntimeException("Unknown taxon");
        }
        return n;
    }

    private NodeRef getTipNode(Taxon taxon) {
        int n = this.getTipIndex(taxon);
        NodeRef nodeRef = this.tree.getExternalNode(n);
        if (this.tree.getNodeTaxon(nodeRef) != taxon) {
            throw new RuntimeException("Unknown taxon");
        }
        return nodeRef;
    }

    private double calculateLogLikelihood() {
        int n = this.accessors.get(0).getPatternCount();
        int[] nArray = new int[n];
        this.accessors.get(0).getTipStates(this.getTipIndex(this.taxon), nArray);
        double[] dArray = this.getProbabilities(this.taxon);
        int n2 = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 >= n2) continue;
            d += Math.log(dArray[n3]);
        }
        return d;
    }

    public double[] getProbabilities(Taxon taxon) {
        double d = this.tree.getNodeHeight(this.getTipNode(taxon));
        int n = 0;
        while (d > this.epochs.get((int)n).cutOff) {
            ++n;
        }
        return this.epochs.get((int)n).distribution.getParameterValues();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        throw new IllegalArgumentException("Unknown model");
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.tipHeight) {
            throw new IllegalArgumentException("Unknown variable");
        }
        this.likelihoodKnown = false;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    public static class Epoch {
        double cutOff;
        Parameter distribution;

        public Epoch(double d, Parameter parameter) {
            this.cutOff = d;
            this.distribution = parameter;
        }
    }
}

