## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(grid)
library(isocubes)

## -----------------------------------------------------------------------------
isopointsGrob(pch = "+", size = 10) |> 
  grid::grid.draw()

## -----------------------------------------------------------------------------
isolinesGrob() |> grid::grid.draw()
isoaxesGrob()  |> grid::grid.draw() # (x,y,z) axis = red, green, blue lines

## ----fig.width=5, fig.height=5------------------------------------------------
# Clear page and set background
grid::grid.newpage()
grid::grid.rect(gp = gpar(fill = 'lightblue'))

# Draw an isometric grid
isolinesGrob(col = 'darkblue', lwd = 3, x = 0.35, y = 0.1) |> 
  grid::grid.draw()

# Draw isometric cubes
isocubesGrob(coords = isocubes::obj_letter, x = 0.35, y = 0.1, xyplane = 'right') |>
  grid::grid.draw()

# Overlap axes
isoaxesGrob(size = 20, x = 0.35, y = 0.1, col = 'yellow', lwd = 8, cex = 2, fontface = 'bold') |>
  grid::grid.draw()

