/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra.missingData;

public class InversionResult {
    private final Code code;
    private final int dim;
    private final double logDeterminant;
    private final boolean isLog;

    InversionResult(Code code, int n, double d, boolean bl) {
        this.code = code;
        this.dim = n;
        this.logDeterminant = d;
        this.isLog = bl;
    }

    public InversionResult(Code code, int n, double d) {
        this(code, n, d, true);
    }

    public final Code getReturnCode() {
        return this.code;
    }

    public final int getEffectiveDimension() {
        assert (this.dim > -1) : "Should not try to get this effective dimension.";
        return this.dim;
    }

    public final double getDeterminant() {
        return this.isLog ? Math.exp(this.logDeterminant) : this.logDeterminant;
    }

    public final double getLogDeterminant() {
        return this.isLog ? this.logDeterminant : Math.log(this.logDeterminant);
    }

    public static InversionResult mult(InversionResult inversionResult, InversionResult inversionResult2) {
        double d = inversionResult.getLogDeterminant() + inversionResult2.getLogDeterminant();
        if (inversionResult.getEffectiveDimension() == 0 || inversionResult2.getEffectiveDimension() == 0) {
            return new InversionResult(Code.NOT_OBSERVED, 0, d, true);
        }
        if (inversionResult.getReturnCode() == Code.FULLY_OBSERVED) {
            return new InversionResult(inversionResult2.getReturnCode(), inversionResult2.getEffectiveDimension(), d, true);
        }
        if (inversionResult2.getReturnCode() == Code.FULLY_OBSERVED) {
            return new InversionResult(inversionResult.getReturnCode(), inversionResult.getEffectiveDimension(), d, true);
        }
        return new InversionResult(Code.PARTIALLY_OBSERVED, -1, d, true);
    }

    public static Code getCode(int n, int n2) {
        Code code = n2 == 0 ? Code.NOT_OBSERVED : (n2 == n ? Code.FULLY_OBSERVED : Code.PARTIALLY_OBSERVED);
        return code;
    }

    public String toString() {
        return (Object)((Object)this.code) + ":" + this.dim + ":" + this.logDeterminant;
    }

    public static enum Code {
        FULLY_OBSERVED,
        NOT_OBSERVED,
        PARTIALLY_OBSERVED;

    }
}

