/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.arima.AbstractArimaModel;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ucarima.SsfUcarima;
import ec.tstoolkit.ssf.ucarima.SsfUcarimaWithMean;
import ec.tstoolkit.ucarima.ModelDecomposer;
import ec.tstoolkit.ucarima.SeasonalSelector;
import ec.tstoolkit.ucarima.TrendCycleSelector;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.utilities.Ref;
import java.util.ArrayList;

public class GeneralizedAirlineModel
extends AbstractArimaModel
implements IArimaModel,
Cloneable {
    double[] m_q;
    int[] m_c;
    int m_pow;
    boolean[] m_fixed;
    int m_freq;
    private boolean m_st;
    private BackFilter m_ma;
    private BackFilter m_ar;
    static double EPS = 1.0E-6;

    static long CKey(SubArrayOfInt c) {
        long l = 0L;
        int i = 0;
        int q = 1;
        while (i < c.getLength()) {
            if (c.get(i) == 2) {
                l += (long)q;
            }
            ++i;
            q <<= 1;
        }
        return l;
    }

    GeneralizedAirlineModel() {
    }

    public GeneralizedAirlineModel(int freq, double[] p, SubArrayOfInt c) {
        this.m_q = (double[])p.clone();
        int nparams = p.length;
        this.m_freq = freq;
        this.m_c = new int[freq / 2 + 2];
        if (c != null) {
            for (int i = 2; i < this.m_c.length; ++i) {
                this.m_c[i] = c.get(i - 2);
            }
        } else {
            for (int i = 2; i < this.m_c.length; ++i) {
                this.m_c[i] = 1;
            }
        }
        this.m_fixed = new boolean[nparams];
        if (nparams == 4) {
            this.m_c[0] = -1;
            this.m_c[1] = -1;
        } else {
            this.m_c[0] = 0;
            this.m_c[1] = 1;
        }
        this.m_pow = this.pow();
        this.m_st = false;
    }

    public GeneralizedAirlineModel(int freq, int nparams, double q, double sq, SubArrayOfInt c) {
        if (q <= 0.0) {
            q = 0.2;
        }
        if (sq <= 0.0) {
            sq = 0.2;
        }
        this.init(freq, nparams, q, sq, c);
    }

    public GeneralizedAirlineModel(int freq, int nparams, int[] c) {
        if (nparams == 0 || c == null) {
            this.init(freq, nparams, 0.2, Math.pow(0.2, 1.0 / (double)freq), null);
        } else {
            int i;
            int[] cc = new int[freq / 2];
            for (i = 0; i < cc.length; ++i) {
                cc[i] = nparams - 2;
            }
            for (i = 0; i < c.length; ++i) {
                cc[c[i] - 1] = nparams - 1;
            }
            this.init(freq, nparams, 0.2, Math.pow(0.2, 1.0 / (double)freq), SubArrayOfInt.create(cc));
        }
    }

    public GeneralizedAirlineModel(int freq, int nparams, SubArrayOfInt c) {
        this.init(freq, nparams, 0.2, Math.pow(0.2, 1.0 / (double)freq), c);
    }

    private void calcAR() {
        if (this.m_ar == null) {
            if (!this.m_st) {
                UnitRoots ur = new UnitRoots();
                ur.add(1);
                ur.add(this.m_freq);
                this.m_ar = BackFilter.of(ur.coefficients());
            } else {
                this.m_ar = BackFilter.ONE;
            }
        }
    }

    private void calcMA() {
        if (this.m_ma == null) {
            double[] p = new double[this.m_freq + 2];
            p[0] = 1.0;
            if (this.m_c[0] == -1) {
                p[1] = this.m_q[0];
                p[2] = this.m_q[1];
            } else {
                p[1] = -(this.m_q[0] + this.m_q[1]);
                p[2] = this.m_q[0] * this.m_q[1];
            }
            int freq2 = (this.m_freq + 1) / 2;
            double z = Math.PI * 2 / (double)this.m_freq;
            for (int i = 1; i < freq2; ++i) {
                double q = this.m_q[this.m_c[1 + i]];
                double b = -2.0 * q * Math.cos(z * (double)i);
                double c = q * q;
                for (int j = 2 * i; j >= 0; --j) {
                    double w = p[j];
                    int n = j + 2;
                    p[n] = p[n] + c * w;
                    int n2 = j + 1;
                    p[n2] = p[n2] + b * w;
                }
            }
            if (this.m_freq % 2 == 0) {
                double q = this.m_q[this.m_c[1 + freq2]];
                for (int i = this.m_freq; i >= 0; --i) {
                    int n = i + 1;
                    p[n] = p[n] + p[i] * q;
                }
            }
            this.m_ma = BackFilter.of(p);
        }
    }

    ArimaModel checkModel(double ubound) {
        Polynomial theta = this.getMA().getPolynomial();
        Ref<Object> thetac = new Ref<Object>(null);
        Utilities.stabilize(theta, ubound, thetac);
        return new ArimaModel(BackFilter.ONE, this.getNonStationaryAR(), new BackFilter((Polynomial)thetac.val), this.getInnovationVariance());
    }

    void checkRoots(double rmax) {
        boolean changed = false;
        int np = this.m_q.length;
        if (np == 4) {
            double ro;
            if (this.m_c[0] < 0 && (ro = this.m_q[0] * this.m_q[0] - 4.0 * this.m_q[1]) >= 0.0) {
                double sro = Math.sqrt(ro);
                double r0 = (-this.m_q[0] + sro) / 2.0;
                double r1 = (-this.m_q[0] - sro) / 2.0;
                if (r0 > rmax) {
                    r0 = rmax;
                }
                if (r1 > rmax) {
                    r1 = rmax;
                }
                this.m_q[0] = -(r0 + r1);
                this.m_q[1] = r0 * r1;
                changed = true;
            }
            double rmax1 = Math.pow(rmax, 1.0 / (double)this.m_pow);
            double rmax2 = Math.pow(rmax, 1.0 / (double)(this.m_freq - this.m_pow - 1));
            if (!this.m_fixed[2] && this.m_q[2] > rmax1) {
                this.m_q[2] = rmax1;
                changed = true;
            }
            if (!this.m_fixed[3] && this.m_q[3] > rmax1) {
                this.m_q[3] = rmax2;
                changed = true;
            }
            if (this.m_c[1] == 1 && !this.m_fixed[1] && this.m_q[1] > rmax) {
                this.m_q[1] = rmax;
                changed = true;
            }
        } else if (np == 3) {
            if (!this.m_fixed[0] && this.m_q[0] > rmax) {
                this.m_q[0] = rmax;
                changed = true;
            }
            double rmax1 = Math.pow(rmax, 1.0 / (double)this.m_pow);
            double rmax2 = Math.pow(rmax, 1.0 / (double)(this.m_freq - this.m_pow));
            if (!this.m_fixed[1] && this.m_q[1] > rmax1) {
                this.m_q[1] = rmax1;
                changed = true;
            }
            if (!this.m_fixed[2] && this.m_q[2] > rmax2) {
                this.m_q[2] = rmax2;
                changed = true;
            }
        } else if (np == 2) {
            if (!this.m_fixed[0] && this.m_q[0] > rmax) {
                this.m_q[0] = rmax;
                changed = true;
            }
            double rmax1 = Math.pow(rmax, 1.0 / (double)this.m_freq);
            if (!this.m_fixed[1] && this.m_q[1] > rmax1) {
                this.m_q[1] = rmax1;
                changed = true;
            }
        }
        if (changed) {
            this.clearCachedObjects();
        }
    }

    ArimaModel checkUR() {
        this.fixUnitRoots(EPS);
        return new ArimaModel(BackFilter.ONE, this.getNonStationaryAR(), this.getMA(), this.getInnovationVariance());
    }

    @Override
    protected void clearCachedObjects() {
        super.clearCachedObjects();
        this.m_ma = null;
    }

    @Override
    public GeneralizedAirlineModel clone() {
        GeneralizedAirlineModel model = (GeneralizedAirlineModel)super.clone();
        if (this.m_c != null) {
            model.m_c = (int[])this.m_c.clone();
        }
        if (this.m_q != null) {
            model.m_q = (double[])this.m_q.clone();
        }
        return model;
    }

    void copy(GeneralizedAirlineModel ga) {
        this.clearCachedObjects();
        this.m_c = (int[])ga.m_c.clone();
        this.m_q = (double[])ga.m_q.clone();
        this.m_fixed = (boolean[])ga.m_fixed.clone();
        this.m_ma = ga.m_ma;
        this.m_st = ga.m_st;
        this.m_pow = ga.m_pow;
        this.m_freq = ga.m_freq;
    }

    private UcarimaModel defaultUCModel(double ubound) {
        ArimaModel model = ubound == 1.0 ? this.checkUR() : this.checkModel(ubound);
        ModelDecomposer decomposer = new ModelDecomposer();
        decomposer.add(new TrendCycleSelector());
        decomposer.add(new SeasonalSelector(this.m_freq));
        UcarimaModel ucm = decomposer.decompose(model);
        ucm.setVarianceMax(-1);
        if (ucm.isValid()) {
            ucm.compact(2, 2);
            return ucm;
        }
        return null;
    }

    public void doStationary(boolean st) {
        super.clearCachedObjects();
        this.m_st = st;
        this.m_ar = null;
    }

    public boolean fixUnitRoots(double eps) {
        int idx = 0;
        boolean rslt = false;
        if (this.m_c[0] < 0) {
            if (this.m_q[1] < 1.0 - eps && Math.abs(1.0 + this.m_q[0] + this.m_q[1]) < eps) {
                this.m_q[0] = 1.0;
                this.m_fixed[0] = true;
                this.m_c[0] = 0;
                this.m_c[1] = 1;
                rslt = true;
            }
            idx = 1;
        }
        for (int i = idx; i < this.m_q.length; ++i) {
            if (this.m_fixed[i] || !(this.m_q[i] > 1.0 - eps)) continue;
            this.m_q[i] = 1.0;
            this.m_fixed[i] = true;
            rslt = true;
        }
        if (rslt) {
            this.clearCachedObjects();
        }
        return rslt;
    }

    public ISsf fullSsfModel(double ubound) {
        if (ubound == 1.0) {
            this.checkUR();
        }
        if (!this.hasFixedParameters()) {
            UcarimaModel tmp = this.defaultUCModel(ubound);
            if (tmp == null) {
                return null;
            }
            return new SsfUcarima(tmp);
        }
        BackFilter ar0 = this.getNonStationaryMA(0);
        BackFilter ar1 = this.getNonStationaryMA(1);
        BackFilter ma = this.getStationaryMA(-1);
        BackFilter ar = this.getNonStationaryMAComplement(-1);
        ArimaModel arima = new ArimaModel(null, ar, ma, 1.0);
        ModelDecomposer decomposer = new ModelDecomposer();
        decomposer.add(new TrendCycleSelector());
        decomposer.add(new SeasonalSelector(this.m_freq));
        UcarimaModel ucm = decomposer.decompose(arima);
        ucm.setVarianceMax(-1);
        if (!ucm.isValid()) {
            return null;
        }
        ucm.compact(2, 2);
        if (ar0.getDegree() != 1) {
            ArrayList<ArimaModel> cmps = new ArrayList<ArimaModel>();
            cmps.add(ucm.getComponent(0));
            if (ar0.getDegree() > 0) {
                cmps.add(new ArimaModel(BackFilter.ONE, ar0, BackFilter.ONE, 0.0));
            }
            cmps.add(ucm.getComponent(1));
            if (ar1.getDegree() > 0) {
                cmps.add(new ArimaModel(BackFilter.ONE, ar1, BackFilter.ONE, 0.0));
            }
            cmps.add(ucm.getComponent(2));
            return new SsfUcarima(new UcarimaModel((IArimaModel)this, cmps));
        }
        UcarimaModel ucmc = new UcarimaModel();
        ArimaModel trend = ucm.getComponent(0);
        ucmc.addComponent(ucm.getComponent(0));
        ucmc.addComponent(ucm.getComponent(1));
        if (ar1.getDegree() > 0) {
            ucmc.addComponent(new ArimaModel(BackFilter.ONE, ar1, BackFilter.ONE, 0.0));
        }
        ucmc.addComponent(ucm.getComponent(2));
        return SsfUcarimaWithMean.build(ucmc);
    }

    public UcarimaModel fullUCModel(double ubound) {
        if (ubound == 1.0) {
            this.checkUR();
        }
        if (!this.hasFixedParameters()) {
            return this.defaultUCModel(ubound);
        }
        BackFilter ar0 = this.getNonStationaryMA(0);
        BackFilter ar1 = this.getNonStationaryMA(1);
        BackFilter ma = this.getStationaryMA(-1);
        BackFilter ar = this.getNonStationaryMAComplement(-1);
        ArimaModel arima = new ArimaModel(null, ar, ma, 1.0);
        ModelDecomposer decomposer = new ModelDecomposer();
        decomposer.add(new TrendCycleSelector());
        decomposer.add(new SeasonalSelector(this.m_freq));
        UcarimaModel ucm = decomposer.decompose(arima);
        ucm.setVarianceMax(-1);
        if (!ucm.isValid()) {
            return null;
        }
        ucm.compact(2, 2);
        ArrayList<ArimaModel> cmps = new ArrayList<ArimaModel>();
        if (ar0.getDegree() != 1) {
            cmps.add(ucm.getComponent(0));
            cmps.add(new ArimaModel(BackFilter.ONE, ar0, BackFilter.ONE, 0.0));
        } else {
            ArimaModel trend = ucm.getComponent(0);
            cmps.add(new ArimaModel(trend.getStationaryAR(), trend.getNonStationaryAR().times(ar0), trend.getMA().times(ar0), trend.getInnovationVariance()));
            cmps.add(new ArimaModel(null, null, null, 0.0));
        }
        cmps.add(ucm.getComponent(1));
        cmps.add(new ArimaModel(BackFilter.ONE, ar1, BackFilter.ONE, 0.0));
        cmps.add(ucm.getComponent(2));
        return new UcarimaModel((IArimaModel)this, cmps);
    }

    @Override
    public BackFilter getAR() {
        if (this.m_st) {
            return BackFilter.ONE;
        }
        this.calcAR();
        return this.m_ar;
    }

    @Override
    public int getARCount() {
        return this.m_st ? 0 : this.m_freq + 1;
    }

    public int[] getC() {
        return this.m_c;
    }

    public double[] getCoefficients() {
        return this.m_q;
    }

    public int getFrequency() {
        return this.m_freq;
    }

    public int[] getFullModelType() {
        int nparams = this.m_q.length;
        if (nparams == 2) {
            return null;
        }
        int gcount = 0;
        for (int i = 0; i < this.m_c.length; ++i) {
            if (this.m_c[i] != nparams - 1) continue;
            ++gcount;
        }
        int[] rslt = new int[gcount];
        int j = 0;
        for (int i = 2; i < this.m_c.length; ++i) {
            if (this.m_c[i] != nparams - 1) continue;
            rslt[j++] = i - 1;
        }
        return rslt;
    }

    @Override
    public double getInnovationVariance() {
        return 1.0;
    }

    @Override
    public BackFilter getMA() {
        this.calcMA();
        return this.m_ma;
    }

    @Override
    public int getMACount() {
        return this.m_freq + 1;
    }

    public String getModelType() {
        int nparams = this.m_q.length;
        if (nparams == 2) {
            return "Airline (2)";
        }
        int gcount = 0;
        for (int i = 0; i < this.m_c.length; ++i) {
            if (this.m_c[i] != nparams - 1) continue;
            ++gcount;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_freq / 2 - gcount);
        builder.append('-');
        builder.append(gcount);
        builder.append(" (").append(nparams).append(')');
        int[] ids = this.getFullModelType();
        if (ids != null) {
            builder.append('{');
            for (int j = 0; j < ids.length; ++j) {
                if (j != 0) {
                    builder.append('-');
                }
                builder.append(ids[j]);
            }
            builder.append('}');
        }
        return builder.toString();
    }

    @Override
    public BackFilter getNonStationaryAR() {
        if (this.m_st) {
            return BackFilter.ONE;
        }
        UnitRoots ur = new UnitRoots();
        ur.add(this.m_freq);
        ur.add(1);
        return new BackFilter(ur.toPolynomial());
    }

    @Override
    public int getNonStationaryARCount() {
        return this.m_st ? 0 : this.m_freq + 1;
    }

    public BackFilter getNonStationaryMA(int part) {
        double[] p = new double[this.m_freq + 2];
        p[0] = 1.0;
        int dcur = 0;
        if (part <= 0) {
            if (this.m_fixed[0] && this.m_fixed[1]) {
                p[1] = -2.0;
                p[2] = 1.0;
                dcur = 2;
            } else if (this.m_fixed[0] || this.m_fixed[1]) {
                p[1] = -1.0;
                dcur = 1;
            }
        }
        if (part != 0) {
            int i;
            int freq2 = (this.m_freq + 1) / 2;
            double z = Math.PI * 2 / (double)this.m_freq;
            for (i = 1; i < freq2; ++i) {
                if (!this.m_fixed[this.m_c[1 + i]]) continue;
                double b = -2.0 * Math.cos(z * (double)i);
                for (int j = dcur; j >= 0; --j) {
                    double w = p[j];
                    int n = j + 2;
                    p[n] = p[n] + w;
                    int n2 = j + 1;
                    p[n2] = p[n2] + b * w;
                }
                dcur += 2;
            }
            if (this.m_freq % 2 == 0 && this.m_fixed[this.m_c[1 + freq2]]) {
                for (i = dcur; i >= 0; --i) {
                    int n = i + 1;
                    p[n] = p[n] + p[i];
                }
                ++dcur;
            }
        }
        double[] q = new double[dcur + 1];
        System.arraycopy(p, 0, q, 0, q.length);
        return BackFilter.of(q);
    }

    public BackFilter getNonStationaryMAComplement(int part) {
        double[] p = new double[this.m_freq + 2];
        p[0] = 1.0;
        int dcur = 0;
        if (part <= 0) {
            if (!this.m_fixed[0] && !this.m_fixed[1]) {
                p[1] = -2.0;
                p[2] = 1.0;
                dcur = 2;
            } else if (!this.m_fixed[0] || !this.m_fixed[1]) {
                p[1] = -1.0;
                dcur = 1;
            }
        }
        if (part != 0) {
            int i;
            int freq2 = (this.m_freq + 1) / 2;
            double z = Math.PI * 2 / (double)this.m_freq;
            for (i = 1; i < freq2; ++i) {
                if (this.m_fixed[this.m_c[1 + i]]) continue;
                double b = -2.0 * Math.cos(z * (double)i);
                double c = 1.0;
                for (int j = dcur; j >= 0; --j) {
                    double w = p[j];
                    int n = j + 2;
                    p[n] = p[n] + c * w;
                    int n2 = j + 1;
                    p[n2] = p[n2] + b * w;
                }
                dcur += 2;
            }
            if (this.m_freq % 2 == 0 && !this.m_fixed[this.m_c[1 + freq2]]) {
                for (i = dcur; i >= 0; --i) {
                    int n = i + 1;
                    p[n] = p[n] + p[i];
                }
                ++dcur;
            }
        }
        double[] q = new double[dcur + 1];
        System.arraycopy(p, 0, q, 0, q.length);
        return BackFilter.of(q);
    }

    public double getParameter(int idx) {
        int j = 0;
        for (int i = 0; i < this.m_q.length; ++i) {
            if (this.m_fixed[i]) continue;
            if (j == idx) {
                return this.m_q[i];
            }
            ++j;
        }
        return 0.0;
    }

    public IReadDataBlock getParameters() {
        double[] p = new double[this.getParametersCount()];
        int j = 0;
        for (int i = 0; i < this.m_q.length; ++i) {
            if (this.m_fixed[i]) continue;
            p[j++] = this.m_q[i];
        }
        return new ReadDataBlock(p);
    }

    public int getParametersCount() {
        int n = 0;
        for (int i = 0; i < this.m_q.length; ++i) {
            if (this.m_fixed[i]) continue;
            ++n;
        }
        return n;
    }

    @Override
    public BackFilter getStationaryAR() {
        return BackFilter.ONE;
    }

    @Override
    public int getStationaryARCount() {
        return 0;
    }

    public BackFilter getStationaryMA(int part) {
        double[] p = new double[this.m_freq + 2];
        p[0] = 1.0;
        int dcur = 0;
        if (part <= 0) {
            if (this.m_c[0] == -1) {
                p[1] = this.m_q[0];
                p[2] = this.m_q[1];
                dcur = 2;
            } else if (!this.m_fixed[0] && !this.m_fixed[1]) {
                p[1] = -(this.m_q[0] + this.m_q[1]);
                p[2] = this.m_q[0] * this.m_q[1];
                dcur = 2;
            } else if (!this.m_fixed[0]) {
                p[1] = -this.m_q[0];
                dcur = 1;
            } else if (!this.m_fixed[1]) {
                p[1] = -this.m_q[1];
                dcur = 1;
            }
        }
        if (part != 0) {
            int freq2 = (this.m_freq + 1) / 2;
            double z = Math.PI * 2 / (double)this.m_freq;
            for (int i = 1; i < freq2; ++i) {
                if (this.m_fixed[this.m_c[1 + i]]) continue;
                double q = this.m_q[this.m_c[1 + i]];
                double b = -2.0 * q * Math.cos(z * (double)i);
                double c = q * q;
                for (int j = dcur; j >= 0; --j) {
                    double w = p[j];
                    int n = j + 2;
                    p[n] = p[n] + c * w;
                    int n2 = j + 1;
                    p[n2] = p[n2] + b * w;
                }
                dcur += 2;
            }
            if (this.m_freq % 2 == 0 && !this.m_fixed[this.m_c[1 + freq2]]) {
                double q = this.m_q[this.m_c[1 + freq2]];
                for (int i = dcur; i >= 0; --i) {
                    int n = i + 1;
                    p[n] = p[n] + q * p[i];
                }
                ++dcur;
            }
        }
        double[] rslt = Polynomial.Doubles.fromDegree(dcur);
        System.arraycopy(p, 0, rslt, 0, dcur + 1);
        return BackFilter.of(rslt);
    }

    public int getType() {
        return this.m_q.length;
    }

    public boolean hasFixedParameters() {
        for (int i = 0; i < this.m_fixed.length; ++i) {
            if (!this.m_fixed[i]) continue;
            return true;
        }
        return false;
    }

    private void init(int freq, int nparams, double q, double sq, SubArrayOfInt c) {
        int i;
        this.m_freq = freq;
        this.m_c = new int[freq / 2 + 2];
        if (c != null) {
            for (i = 2; i < this.m_c.length; ++i) {
                this.m_c[i] = c.get(i - 2);
            }
        } else {
            for (i = 2; i < this.m_c.length; ++i) {
                this.m_c[i] = 1;
            }
        }
        this.m_q = new double[nparams];
        this.m_fixed = new boolean[nparams];
        int idx = 0;
        if (nparams == 4) {
            this.m_q[0] = -(q + sq);
            this.m_q[1] = q * sq;
            this.m_c[0] = -1;
            this.m_c[1] = -1;
            idx = 2;
        } else {
            this.m_q[0] = q;
            this.m_c[0] = 0;
            this.m_c[1] = 1;
            idx = 1;
        }
        for (int i2 = idx; i2 < nparams; ++i2) {
            this.m_q[i2] = sq;
        }
        this.m_pow = this.pow();
        this.m_st = false;
    }

    public boolean isFixed(int idx) {
        return this.m_fixed[idx];
    }

    @Override
    public boolean isInvertible() {
        int idx = 0;
        if (this.m_c[1] == -1) {
            if (Math.abs(1.0 + this.m_q[0] + this.m_q[1]) <= EPS || Math.abs(this.m_q[1] - 1.0) <= EPS * EPS) {
                return false;
            }
            idx = 2;
        }
        for (int i = idx; i < this.m_q.length; ++i) {
            if (!(Math.abs(1.0 - this.m_q[i]) <= EPS)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isStationary() {
        return this.m_st;
    }

    final int pow() {
        int n = (this.m_freq - 1) / 2;
        int nparams = this.m_q.length;
        int idx = nparams == 4 ? 2 : 1;
        int p = nparams == 4 ? 0 : 1;
        for (int i = 1; i <= n; ++i) {
            if (this.m_c[i + 1] != idx) continue;
            p += 2;
        }
        if (this.m_freq % 2 == 0 && this.m_c[n + 2] == idx) {
            ++p;
        }
        return p;
    }

    public void resetFixedParameters(double u) {
        for (int i = 0; i < this.m_q.length; ++i) {
            if (!this.m_fixed[i]) continue;
            this.m_fixed[i] = false;
            this.m_q[i] = u;
        }
        this.clearCachedObjects();
    }

    public void setParameter(int idx, double value) {
        int j = 0;
        for (int i = 0; i < this.m_q.length; ++i) {
            if (this.m_fixed[i]) continue;
            if (j == idx) {
                this.m_q[i] = value;
                this.clearCachedObjects();
                return;
            }
            ++j;
        }
    }

    public void setParameters(IReadDataBlock value) {
        int j = 0;
        for (int i = 0; i < this.m_q.length; ++i) {
            if (this.m_fixed[i]) continue;
            this.m_q[i] = value.get(j++);
        }
        this.clearCachedObjects();
    }

    @Override
    public StationaryTransformation stationaryTransformation() {
        this.calcAR();
        this.calcMA();
        GeneralizedAirlineModel ga = this.clone();
        ga.doStationary(true);
        StationaryTransformation transformation = new StationaryTransformation(ga, this.m_ar);
        return transformation;
    }

    public UcarimaModel toUCModel(double ubound) {
        if (ubound < 1.0) {
            return this.defaultUCModel(ubound);
        }
        this.checkUR();
        BackFilter ar0 = this.getNonStationaryMA(0);
        BackFilter ar1 = this.getNonStationaryMA(1);
        BackFilter ma = this.getStationaryMA(-1);
        BackFilter ar = this.getNonStationaryMAComplement(-1);
        ArimaModel arima = new ArimaModel(null, ar, ma, 1.0);
        ModelDecomposer decomposer = new ModelDecomposer();
        decomposer.add(new TrendCycleSelector());
        decomposer.add(new SeasonalSelector(this.m_freq));
        UcarimaModel ucm = decomposer.decompose(arima);
        ucm.setVarianceMax(-1);
        if (!ucm.isValid()) {
            return null;
        }
        ucm.compact(2, 2);
        ArrayList<ArimaModel> cmps = new ArrayList<ArimaModel>();
        ArimaModel trend = ucm.getComponent(0);
        if (ar0.getDegree() > 0) {
            cmps.add(new ArimaModel(trend.getStationaryAR(), trend.getNonStationaryAR().times(ar0), trend.getMA().times(ar0), trend.getInnovationVariance()));
        } else {
            cmps.add(trend);
        }
        ArimaModel seas = ucm.getComponent(1);
        if (ar1.getDegree() > 0) {
            cmps.add(new ArimaModel(seas.getStationaryAR(), seas.getNonStationaryAR().times(ar1), seas.getMA().times(ar1), seas.getInnovationVariance()));
        } else {
            cmps.add(seas);
        }
        cmps.add(ucm.getComponent(2));
        return new UcarimaModel((IArimaModel)this, cmps);
    }
}

