/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.ProcessingInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SequentialProcessing<I>
implements IProcessing<I, CompositeResults>,
Cloneable {
    public static final String INPUT = "input";
    private ArrayList<IProcessingNode<I>> nodes_ = new ArrayList();

    public SequentialProcessing clone() {
        try {
            SequentialProcessing p = (SequentialProcessing)super.clone();
            return p;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void add(IProcessingNode<I> node) {
        this.nodes_.add(node);
    }

    @Override
    public CompositeResults process(I input) {
        CompositeResults results = new CompositeResults();
        HashMap<String, IProcResults> map = new HashMap<String, IProcResults>();
        boolean ok = true;
        for (IProcessingNode<I> cur : this.nodes_) {
            String name = cur.getName();
            if (!ok) {
                results.put(name, null, null);
                continue;
            }
            try {
                List<ProcessingInformation> infos;
                IProcResults r;
                IProcessing.Status st = cur.process(input, map);
                if (st == IProcessing.Status.Valid) {
                    results.put(name, map.get(name), cur.getPrefix());
                } else if (st == IProcessing.Status.Invalid) {
                    ok = false;
                    results.put(name, null, null);
                    results.addInformation(ProcessingInformation.error(name, "failed"));
                }
                if ((r = map.get(name)) == null || (infos = r.getProcessingInformation()).isEmpty()) continue;
                results.addInformation(ProcessingInformation.addPrefix(infos, name));
            }
            catch (Exception err) {
                ok = false;
                results.put(name, null, null);
                results.addInformation(ProcessingInformation.error(name, err));
            }
        }
        return results;
    }
}

